#ifndef __gxframework_stepper_h__
	#define __gxframework_stepper_h__

#include "shared.h"

namespace Gx
{
	class Game;

	class GXFRAMEWORK_DECLSPEC Stepper
	{
	public:
		Stepper(float timeStep = 1.0f / 60.0f, float maxAccumulatedTime = 1.0f);

		void advance(Game& game, float elapsedTime); // w sekundach

		inline void reset() {
			m_timeAccumulator = 0;
		}

		inline float getFps() const {
			return m_fpsCounter;
		}

	private:
		float			m_fpsTimeAccumulator;
		float			m_fpsCounter;
		unsigned int	m_framesCounter;

		float			m_timeAccumulator;
		const float		m_maxAccumulatedTime;
		const float		m_timeStep;
	};
}

#endif // ~__gxframework_stepper_h__
